%macro explore(data,id,wholefruit, wholegrains, refinedgrains, dairy, sugars, satfat, sodium, kcal,mufapufa,
               totalfruit, beansandgreens, vegandlegumes, seafoodplant, allprotein, 
               fruitjuice, nondarkgr, darkgr, legumes, seasoynut, mpeggs);
  
   /***STEP 3: EXPLORE DATA CHARACTERISTICS    ***/
               
  /*******************************************************************************************/
  /*** the fitdistrib macro is used in conjunction with the HEI Wrapper                    ***/
  /*** example of how to fit an MCMC model using NHANES data and BRR                       ***/
  /*** weights to obtain distributions. This is STEP 3.                                    ***/
  /***                                                                                     ***/
  /*** the macro "explore" determines which dietary components are considered to be        ***/
  /*** consumed episodically and which are considered to be consumed daily for             ***/
  /*** each type of analysis (all, MCMC or usual), and produces a report in the .lst file. ***/ 
  /*** The macro does a separate analysis for each stratum. If the analysis is not         ***/
  /*** stratified then the variable 'stratum' should be coded as 1.                        ***/ 
  /*** This information is needed to correctly assign variables as episodic or daily       ***/
  /*** in calls to subsequent macros. If necessary the user can halt the remainder         ***/
  /*** of the program until the report has been  reviewed by inserting "ENDSAS;"           ***/
  /*** immediately after the calls to the macro explore.                                   ***/
  /*******************************************************************************************/
 
  
  /***********************************************************************************************/
  /***                           ---- Parameter Names ----                                     ***/ 
  /***                                                                                         ***/
  /*** data           = the name of the data set                                               ***/
  /*** id             = the name of the variable with the unique personal identifier           ***/
  /***                                                                                         ***/
  /***         ---- The following paramters identify the food groups to be used ---            ***/
  /*** wholefruit     =  Intact or cut fruit in cup equivalents                                ***/
  /*** wholegrains    =  Whole grains in oz. equivalents                                       ***/
  /*** refinedgrains  =  Refined grains in oz. equivalents                                     ***/
  /*** dairy          =  Total dairy in cup equivalents                                        ***/
  /*** sugars         =  Added sugars in teaspoon equivalents                                  ***/
  /*** satfat         =  Saturated fatty acids in grams                                        ***/
  /*** sodium         =  Sodium in milligrams                                                  ***/
  /*** kcal           =  Total kcals (energy)                                                  ***/
  /*** mufapufa       =  Monounsaturated+polyunsaturated fatty acids in grams                  ***/
  /*** totalfruit     =  Total fruit in cup equivalents                                        ***/
  /*** beansandgreens =  Beans, peas and dark green vegetables in cup equivalents              ***/
  /*** vegandlegumes  =  All vegetables plus legumes in cup equivalents                        ***/
  /*** seafoodplant   =  Seafood, fish and plant protein (includes legumes) in oz. equivalents ***/
  /*** allprotein     =  Protein in oz. equivalents                                            ***/
  /*** fruitjuice     =  Fruit juice in cup equivalents                                        ***/
  /*** nondarkgr      =  Non-dark green vegetables in cup equivalents                          ***/
  /*** darkgr         =  Dark green vegetables in cup equivalents                              ***/
  /*** legumes        =  Legumes in cup equivalents                                            ***/
  /*** seasoynut      =  Seafood, fish, soy protein, nuts & seeds in oz. equivalents           ***/
  /*** mpeggs         =  Meat, Poultry and Eggs in oz. equivalents                             ***/
  /***********************************************************************************************/ 
 
  
  /*********************************************************/
  /** create a macro variable "list"that includes only    **/
  /** the food variables to be used in this execution     **/
  /*********************************************************/ 
 
 ods noresults;
  
  %let list=&wholefruit &wholegrains &refinedgrains &dairy &sugars &satfat &sodium &kcal &mufapufa &totalfruit &beansandgreens &vegandlegumes &seafoodplant &allprotein &fruitjuice 
  &nondarkgr &darkgr &legumes &seasoynut &mpeggs;
  
  %put The variables considered are &list;
  
  ** Count the number of words in the macro variable list **;
  %local count;
  %let count=0; 
  %do %while(%qscan(&list,&count+1,%str( )) ne %str());
  %let count = %eval(&count+1); 
  %end;
  
  %put The number of variables is &count;
  
  /************************************************/
  /** Create a macro variable ind_list with each **/
  /** food variable name suffixed by _01         **/    
  /************************************************/
  ;
  
  data _null_;
    format k $32. indlist $450.;
    indlist='';
    %do i = 1 %to &count;
          k="%scan(&list,&i)";
    		  if &i=1 then indlist=k;
    		  else if &i ne &count then indlist=trim(indlist)||'_01 '||strip(k); 
    		  else if &i=&count then indlist=trim(indlist)||'_01 '||strip(k)||'_01'; 
    %end;
    call symput('ind_list',indlist);
    drop k;
  run;
  %put ind_list = &ind_list;
 
  /***************************************************************/
  /** Determine whether each dietary component is consumed      **/
  /** episodically or daily by type of anlaysis and by stratum. **/
  /** For each dietary component                                **/
  /** if the days of non-consumption (0 intake) are:            **/
  /** <5%    = Not episodic (i.e. daily consumption)            **/
  /** 5%-10% = Marginal - User should determine -               **/
  /** >10%   = Episodic.                                        **/
  /***************************************************************/
 
  
  data explore ;
    set &data;
    array COMP  (&count) &list;
    array COMPI (&count) &ind_list;
      do i=1 to &count;
        COMPI[i]=0;
        if COMP[i]>0 then COMPI[i]=1;
      end;
    drop i;
  run;
  
  proc sort data=explore; by &id stratum;
  
  proc means noprint data=explore noprint sum; by &id stratum;
    var &ind_list;
    output out=sumsi sum= ;
    run;
  
  data sumsi; set sumsi(drop=_TYPE_ _FREQ_);
    array COMPI (&count) &ind_list;
    do i=1 to &count;
      if COMPI[i]>=2 then COMPI[i]=2; **IF HAVE MORE THAN 2 DAYS;
    end;
    drop i;
  run;
  
  data allfreqs; run;
  
  
  %macro getper(var);
  
    proc freq noprint data=sumsi; 
      tables stratum/out=strata;
    run;
    
    data strata; set strata(drop=percent rename=(count=STRATUM_COUNT)); run;
    
    proc freq noprint data=sumsi; 
      tables stratum*&var/ out=sumsf;
    run;
    
    data sumsf; format COMPONENT $14.; merge sumsf strata; by stratum; COMPONENT="&var"; run;
    
    data allfreqs;
      set allfreqs sumsf(rename=(&var=days));
      if component ne '';
    run;
  
  %mend;
  
  %do j = 1 %to &count;
  %getper(%scan(&ind_list,&j))
  %end;
  
  /*proc datasets nolist; delete allfreqs sumsf; run;*/
  
  proc sort data=allfreqs; by stratum component;
  
  proc format;
  value type 1='All'
             2='Usual'
  		       3='MCMC';
  value epi  0='Not Episodic'
             1='Episodic'
  		       2='Marginal';
  value flag 0=' '
             1='N may not be sufficient';
  run;
  
  data allfreqs0; set allfreqs; if days=0; PERCENT_0=(COUNT*100)/STRATUM_COUNT; keep stratum component percent_0; run;
  data allfreqs2; set allfreqs(rename=(count=COUNT_2)); if days=2; keep stratum component count_2; run;
  data allfreqs02; format type type. episodic epi. flag flag.;merge allfreqs0 allfreqs2; by stratum component; 
    if percent_0=. then percent_0=0; 
    component=substr(component, 1, length(component)-3);
    if first.stratum then obs=0; 
    obs+1;
    if component in ("&wholefruit", "&wholegrains", "&refinedgrains", "&dairy", "&sugars", "&satfat", "&sodium", "&kcal","&mufapufa") then type=1;
    if component in ("&totalfruit", "&beansandgreens","&vegandlegumes", "&seafoodplant", "&allprotein") then type=2;
    if component in ("&fruitjuice", "&nondarkgr", "&darkgr", "&legumes", "&seasoynut", "&mpeggs") then type=3;
    if percent_0<5 then episodic=0;
    if percent_0>10 then episodic=1;
    if 5<=percent_0<=10 then episodic=2;
    if count_2<50 then flag=1; else flag=0;
  run;
  
  proc sort; by component stratum; run;
  
  proc sort data=&data; by stratum;
  proc means n nmiss min max mean data=&data; by stratum;
    var  &list;
    output out=mins min=;
  run;
  
  data mins;set mins(drop=_type_ _freq_); run;  
  
  proc transpose data=mins out=mint; by stratum; run;
  
  data mint; set mint(rename=(_name_=component col1=min));
  
  proc sort; by component stratum; run;
  
  data allfreqs02min;
    merge allfreqs02 mint; by component stratum;
    label stratum='Stratum';
  run;
  
  proc sort; by stratum type percent_0 count_2 component; run;
  
  
  %macro headerBW;
  	split='^' ps=42 ls=170 center headline nowd
  	style(report)={just=center}
  	style(header)={just=center foreground=black background=white font_face=arial
                   font_size=2 font_weight=bold}
  
  %mend;
  
  %macro style1;
          style(header)={just=center foreground=black background=white font_face=arial
                          font_size=2 font_weight=bold}
           style(column)={just=CENTER foreground=black background=white font_face=arial
                          font_size=2 cellwidth=1in}
  %mend;
  %macro style2;
          style(header)={just=center foreground=black background=white font_face=arial
                          font_size=2 font_weight=bold}
           style(column)={just=RIGHT foreground=black background=white font_face=arial
                          font_size=2 cellwidth=1in}
  %mend;
  %macro style3;
          style(header)={just=center foreground=black background=white font_face=arial
                          font_size=2 font_weight=bold}
           style(column)={just=LEFT foreground=black background=white font_face=arial
                          font_size=2 cellwidth=1in}
  %mend;
  
  /***************************************************************************/
  /** create a report showing dietary components as episodic or daily       **/
  /***************************************************************************/
  ;
  
  *****************************************************************
  ** send the report to a .pdf named Component_Characteristics.  **
  *****************************************************************;
  ods pdf file="&liblabel.Component_Characteristics.pdf" ;
  
  proc report data=allfreqs02min %headerBW;
   title%eval(&titles+3) h=5 font=arial "Component Characteristics";
    
   columns type component stratum percent_0 episodic /*min*/ count_2 flag;
  	
    define type/order          "Used for" Left flow %style3;
  	define component/order     "HEI Component" %style3;
  	define stratum /order      "Stratum" order=formatted "" Left flow %style3;
  	define percent_0/display   "Percent 0" format=8.1 %style2;
  	define episodic/display    "Episodic" %style1;
  	*define min/display "Minimum value" format=8.2 %style2;
  	define count_2/display     "Number with 2+ non-zero recalls" %style2;
  	define flag/display        "Note" %style3;
  	break after component/;
  
  run;
  
  ods pdf close ;
  
  %mend;

